package main

import (
	"context"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/manager"
)

func (d *discoveryServer) AddFeaturedCarouselEntry(ctx context.Context, req *discovery.AddFeaturedCarouselEntryRequest) (*discovery.AddFeaturedCarouselEntryResponse, error) {
	err := data.ValidateAddFeaturedCarouselEntry(req)
	if err != nil {
		return nil, err
	}

	m, err := manager.LoadDiscoveryManager(ctx)
	if err != nil {
		return nil, err
	}

	entry, err := m.CreateFeaturedCarouselEntry(ctx, req)
	if err != nil {
		return nil, err
	}

	return &discovery.AddFeaturedCarouselEntryResponse{
		FeaturedCarouselEntry: entry,
	}, nil
}
