package main

import (
	"context"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/manager"
)

func (d *discoveryServer) AddFeaturedSchedule(ctx context.Context, req *discovery.AddFeaturedScheduleRequest) (*discovery.AddFeaturedScheduleResponse, error) {
	err := data.ValidateAddFeaturedSchedule(req)
	if err != nil {
		return nil, err
	}

	m, err := manager.LoadDiscoveryManager(ctx)
	if err != nil {
		return nil, err
	}

	schedule, err := m.CreateFeaturedSchedule(ctx, req)
	if err != nil {
		return nil, err
	}

	return &discovery.AddFeaturedScheduleResponse{
		FeaturedSchedule: schedule,
	}, nil
}
