package main

import (
	"context"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/manager"
)

func (d *discoveryServer) AddGameToExtension(ctx context.Context, req *discovery.AddGameToExtensionRequest) (*discovery.AddGameToExtensionResponse, error) {
	err := data.ValidateAddGameToExtension(req)
	if err != nil {
		return nil, err
	}

	m, err := manager.LoadDiscoveryManager(ctx)
	if err != nil {
		return nil, err
	}

	resp, err := m.AddGameToExtension(ctx, req)
	if err != nil {
		return nil, err
	}

	return resp, nil
}
