package main

import (
	"context"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/manager"
)

func (d *discoveryServer) DeleteCategory(ctx context.Context, req *discovery.DeleteCategoryRequest) (*discovery.DeleteCategoryResponse, error) {
	err := data.ValidateDeleteCategory(req)
	if err != nil {
		return nil, err
	}

	m, err := manager.LoadDiscoveryManager(ctx)
	if err != nil {
		return nil, err
	}

	resp, err := m.DeleteCategory(ctx, req)
	if err != nil {
		return nil, err
	}

	return resp, err
}
