package main

import (
	"context"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/manager"
)

func (d *discoveryServer) DeleteExtensionVersionDiscoveryData(ctx context.Context, req *discovery.DeleteExtensionVersionDiscoveryDataRequest) (*discovery.DeleteExtensionVersionDiscoveryDataResponse, error) {
	err := data.ValidateDeleteExtensionVersionDiscoveryData(req)
	if err != nil {
		return nil, err
	}

	m, err := manager.LoadDiscoveryManager(ctx)
	if err != nil {
		return nil, err
	}

	err = m.DeleteExtensionVersionDiscoveryData(ctx, req)
	if err != nil {
		return nil, err
	}

	return &discovery.DeleteExtensionVersionDiscoveryDataResponse{
		Success: true,
	}, nil
}
