package main

import (
	"context"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/manager"
)

func (d *discoveryServer) DeleteFeaturedCarousel(ctx context.Context, req *discovery.DeleteFeaturedCarouselRequest) (*discovery.DeleteFeaturedCarouselResponse, error) {
	err := data.ValidateDeleteFeaturedCarousel(req)
	if err != nil {
		return nil, err
	}

	m, err := manager.LoadDiscoveryManager(ctx)
	if err != nil {
		return nil, err
	}

	carousel, err := m.DeleteFeaturedCarousel(ctx, req)
	if err != nil {
		return nil, err
	}

	return &discovery.DeleteFeaturedCarouselResponse{
		FeaturedCarousel: carousel,
	}, nil
}
