package main

import (
	"context"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/manager"
)

func (d *discoveryServer) DeleteFeaturedSchedule(ctx context.Context, req *discovery.DeleteFeaturedScheduleRequest) (*discovery.DeleteFeaturedScheduleResponse, error) {
	err := data.ValidateDeleteFeaturedSchedule(req)
	if err != nil {
		return nil, err
	}

	m, err := manager.LoadDiscoveryManager(ctx)
	if err != nil {
		return nil, err
	}

	schedule, err := m.DeleteFeaturedSchedule(ctx, req)
	if err != nil {
		return nil, err
	}

	return &discovery.DeleteFeaturedScheduleResponse{
		FeaturedSchedule: schedule,
	}, nil
}
