package main

import (
	"context"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/manager"
)

func (d *discoveryServer) DeleteGameFromExtension(ctx context.Context, req *discovery.DeleteGameFromExtensionRequest) (*discovery.DeleteGameFromExtensionResponse, error) {
	err := data.ValidateDeleteGameFromExtension(req)
	if err != nil {
		return nil, err
	}

	m, err := manager.LoadDiscoveryManager(ctx)
	if err != nil {
		return nil, err
	}

	resp, err := m.DeleteGameFromExtension(ctx, req)
	if err != nil {
		return nil, err
	}

	return resp, nil
}
