package main

import (
	"code.justin.tv/amzn/TwitchTelemetry"
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data/model"
	"code.justin.tv/extensions/discovery/golibs/logger"
)

var _ discovery.Discovery = new(discoveryServer)

type discoveryServer struct {
	config discoveryConfig
	store  model.Store
	logger logger.Logger
	// This struct provides methods for submitting custom metrics
	sampleReporter telemetry.SampleReporter
	// rollbarClient rollbar.Client
	// sandstorm     *manager.Manager
}

func NewDiscoveryServer(config discoveryConfig, store model.Store, sampleReporter telemetry.SampleReporter, logger logger.Logger) (*discoveryServer, error) {
	return &discoveryServer{
		sampleReporter: sampleReporter,
		logger:         logger,
		config:         config,
		store:          store,
	}, nil
}
