package main

import (
	"context"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/manager"
)

func (d *discoveryServer) EditCategoryTranslation(ctx context.Context, req *discovery.EditCategoryTranslationRequest) (*discovery.EditCategoryTranslationResponse, error) {
	err := data.ValidateEditCategoryTranslation(req)
	if err != nil {
		return nil, err
	}

	m, err := manager.LoadDiscoveryManager(ctx)
	if err != nil {
		return nil, err
	}

	cat, err := m.EditCategoryTranslation(ctx, req)
	if err != nil {
		return nil, err
	}

	return &discovery.EditCategoryTranslationResponse{
		Category: cat,
	}, nil
}
