package main

import (
	"context"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/manager"
)

func (d *discoveryServer) GetCategories(ctx context.Context, req *discovery.GetCategoriesRequest) (*discovery.GetCategoriesResponse, error) {
	err := data.ValidateGetCategories(req)
	if err != nil {
		return nil, err
	}

	m, err := manager.LoadDiscoveryManager(ctx)
	if err != nil {
		return nil, err
	}

	cats, err := m.GetCategories(ctx, req)
	if err != nil {
		return nil, err
	}

	return &discovery.GetCategoriesResponse{
		Categories: cats,
	}, nil
}
