package main

import (
	"context"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/manager"
)

func (d *discoveryServer) GetCategory(ctx context.Context, req *discovery.GetCategoryRequest) (*discovery.GetCategoryResponse, error) {
	err := data.ValidateGetCategory(req)
	if err != nil {
		return nil, err
	}

	m, err := manager.LoadDiscoveryManager(ctx)
	if err != nil {
		return nil, err
	}

	cat, err := m.GetCategory(ctx, req)
	if err != nil {
		return nil, err
	}

	return &discovery.GetCategoryResponse{
		Category: cat,
	}, nil
}
