package main

import (
	"context"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/manager"
)

func (d *discoveryServer) GetCategoryExtensions(ctx context.Context, req *discovery.GetCategoryExtensionsRequest) (*discovery.GetCategoryExtensionsResponse, error) {
	err := data.ValidateGetCategoryExtensions(req)
	if err != nil {
		return nil, err
	}

	m, err := manager.LoadDiscoveryManager(ctx)
	if err != nil {
		return nil, err
	}

	cats, err := m.GetExtensionsForCategory(ctx, req)
	if err != nil {
		return nil, err
	}

	return &discovery.GetCategoryExtensionsResponse{
		CategoryExtensions: cats,
	}, nil
}
