package main

import (
	"context"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/manager"
)

func (d *discoveryServer) GetExtensionVersionDiscoveryData(ctx context.Context, req *discovery.GetExtensionVersionDiscoveryDataRequest) (*discovery.GetExtensionVersionDiscoveryDataResponse, error) {
	err := data.ValidateGetExtensionVersionDiscoveryData(req)
	if err != nil {
		return nil, err
	}

	m, err := manager.LoadDiscoveryManager(ctx)
	if err != nil {
		return nil, err
	}

	discoData, err := m.GetExtensionVersionDiscoveryData(ctx, req)
	if err != nil {
		return nil, err
	}

	return &discovery.GetExtensionVersionDiscoveryDataResponse{
		ExtensionVersionData: discoData,
	}, nil
}
