package main

import (
	"context"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/manager"
)

func (d *discoveryServer) GetFeaturedCarousel(ctx context.Context, req *discovery.GetFeaturedCarouselRequest) (*discovery.GetFeaturedCarouselResponse, error) {
	err := data.ValidateGetFeaturedCarousel(req)
	if err != nil {
		return nil, err
	}

	m, err := manager.LoadDiscoveryManager(ctx)
	if err != nil {
		return nil, err
	}

	carousel, err := m.GetFeaturedCarousel(ctx, req)
	if err != nil {
		return nil, err
	}

	return &discovery.GetFeaturedCarouselResponse{
		FeaturedCarousel: carousel,
	}, nil
}
