package main

import (
	"context"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/manager"
)

func (d *discoveryServer) GetFeaturedCarouselEntries(ctx context.Context, req *discovery.GetFeaturedCarouselEntriesRequest) (*discovery.GetFeaturedCarouselEntriesResponse, error) {
	err := data.ValidateGetFeaturedCarouselEntries(req)
	if err != nil {
		return nil, err
	}

	m, err := manager.LoadDiscoveryManager(ctx)
	if err != nil {
		return nil, err
	}

	resp, err := m.GetFeaturedCarouselEntries(ctx, req)
	if err != nil {
		return nil, err
	}

	return &discovery.GetFeaturedCarouselEntriesResponse{
		Entries: resp.CarouselEntries,
		Count:   resp.Count,
	}, nil
}
