package main

import (
	"context"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/manager"
)

func (d *discoveryServer) GetFeaturedCarouselEntry(ctx context.Context, req *discovery.GetFeaturedCarouselEntryRequest) (*discovery.GetFeaturedCarouselEntryResponse, error) {
	err := data.ValidateGetFeaturedCarouselEntry(req)
	if err != nil {
		return nil, err
	}

	m, err := manager.LoadDiscoveryManager(ctx)
	if err != nil {
		return nil, err
	}

	entry, err := m.GetFeaturedCarouselEntry(ctx, req)
	if err != nil {
		return nil, err
	}

	return &discovery.GetFeaturedCarouselEntryResponse{
		FeaturedCarouselEntry: entry,
	}, nil
}
