package main

import (
	"context"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/manager"
)

func (d *discoveryServer) GetFeaturedCarousels(ctx context.Context, req *discovery.GetFeaturedCarouselsRequest) (*discovery.GetFeaturedCarouselsResponse, error) {
	err := data.ValidateGetFeaturedCarousels(req)
	if err != nil {
		return nil, err
	}

	m, err := manager.LoadDiscoveryManager(ctx)
	if err != nil {
		return nil, err
	}

	carousels, err := m.GetFeaturedCarousels(ctx, req)
	if err != nil {
		return nil, err
	}

	return &discovery.GetFeaturedCarouselsResponse{
		FeaturedCarousels: carousels,
	}, nil
}
