package main

import (
	"context"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/manager"
)

func (d *discoveryServer) GetFeaturedSchedule(ctx context.Context, req *discovery.GetFeaturedScheduleRequest) (*discovery.GetFeaturedScheduleResponse, error) {
	err := data.ValidateGetFeaturedSchedule(req)
	if err != nil {
		return nil, err
	}

	m, err := manager.LoadDiscoveryManager(ctx)
	if err != nil {
		return nil, err
	}

	schedule, err := m.GetFeaturedSchedule(ctx, req)
	if err != nil {
		return nil, err
	}

	return &discovery.GetFeaturedScheduleResponse{
		FeaturedSchedule: schedule,
	}, nil
}
