package main

import (
	"context"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/manager"
)

func (d *discoveryServer) GetFeaturedSchedules(ctx context.Context, req *discovery.GetFeaturedSchedulesRequest) (*discovery.GetFeaturedSchedulesResponse, error) {
	err := data.ValidateGetFeaturedSchedules(req)
	if err != nil {
		return nil, err
	}

	m, err := manager.LoadDiscoveryManager(ctx)
	if err != nil {
		return nil, err
	}

	resp, err := m.GetFeaturedSchedules(ctx, req)
	if err != nil {
		return nil, err
	}

	return &discovery.GetFeaturedSchedulesResponse{
		Schedules: resp,
	}, nil
}
