package main

import (
	"context"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/manager"
)

func (d *discoveryServer) HardDeleteExtensionDiscoveryData(ctx context.Context, req *discovery.HardDeleteExtensionDiscoveryDataRequest) (*discovery.HardDeleteExtensionDiscoveryDataResponse, error) {
	err := data.ValidateHardDeleteExtensionDiscoveryData(req)
	if err != nil {
		return nil, err
	}

	m, err := manager.LoadDiscoveryManager(ctx)
	if err != nil {
		return nil, err
	}

	err = m.HardDeleteExtensionDiscoveryData(ctx, req)
	if err != nil {
		return nil, err
	}

	return &discovery.HardDeleteExtensionDiscoveryDataResponse{
		Success: true,
	}, nil
}
