package main

import (
	"context"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/manager"
)

func (d *discoveryServer) OrderCategories(ctx context.Context, req *discovery.OrderCategoriesRequest) (*discovery.OrderCategoriesResponse, error) {
	err := data.ValidateOrderCategories(req)
	if err != nil {
		return nil, err
	}

	m, err := manager.LoadDiscoveryManager(ctx)
	if err != nil {
		return nil, err
	}

	categories, err := m.OrderCategories(ctx, req)
	if err != nil {
		return nil, err
	}

	return &discovery.OrderCategoriesResponse{
		CategoryOrder: &discovery.CategoryOrderDocument{
			CategoryOrder: categories,
		},
	}, nil
}
