package main

import (
	"context"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/manager"
)

func (d *discoveryServer) OrderCategory(ctx context.Context, req *discovery.OrderCategoryRequest) (*discovery.OrderCategoryResponse, error) {
	err := data.ValidateOrderCategory(req)
	if err != nil {
		return nil, err
	}

	m, err := manager.LoadDiscoveryManager(ctx)
	if err != nil {
		return nil, err
	}

	cat, err := m.OrderCategory(ctx, req)
	if err != nil {
		return nil, err
	}

	return &discovery.OrderCategoryResponse{
		Category: cat,
	}, nil
}
