package main

import (
	"context"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/manager"
)

func (d *discoveryServer) OrderFeaturedCarousel(ctx context.Context, req *discovery.OrderFeaturedCarouselRequest) (*discovery.OrderFeaturedCarouselResponse, error) {
	err := data.ValidateOrderFeaturedCarousel(req)
	if err != nil {
		return nil, err
	}

	m, err := manager.LoadDiscoveryManager(ctx)
	if err != nil {
		return nil, err
	}

	carousel, err := m.OrderFeaturedCarousel(ctx, req)
	if err != nil {
		return nil, err
	}

	return &discovery.OrderFeaturedCarouselResponse{
		FeaturedCarousel: carousel,
	}, nil
}
