package main

import (
	"context"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/manager"
)

func (d *discoveryServer) PutExtensionVersionDiscoveryData(ctx context.Context, req *discovery.PutExtensionVersionDiscoveryDataRequest) (*discovery.PutExtensionVersionDiscoveryDataResponse, error) {
	err := data.ValidatePutExtensionVersionDiscoveryData(req)
	if err != nil {
		return nil, err
	}

	m, err := manager.LoadDiscoveryManager(ctx)
	if err != nil {
		return nil, err
	}

	versionData, err := m.PutExtensionVersionDiscoveryData(ctx, req)
	if err != nil {
		return nil, err
	}

	return &discovery.PutExtensionVersionDiscoveryDataResponse{
		ExtensionVersionData: versionData,
	}, nil
}
