package main

import (
	"context"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/manager"
)

func (d *discoveryServer) RemoveExtensionFromCategory(ctx context.Context, req *discovery.RemoveExtensionFromCategoryRequest) (*discovery.RemoveExtensionFromCategoryResponse, error) {
	err := data.ValidateRemoveExtensionFromCategory(req)
	if err != nil {
		return nil, err
	}

	m, err := manager.LoadDiscoveryManager(ctx)
	if err != nil {
		return nil, err
	}

	membership, err := m.RemoveExtensionFromCategory(ctx, req)
	if err != nil {
		return nil, err
	}

	return &discovery.RemoveExtensionFromCategoryResponse{
		ExtensionCategoryMembership: membership,
	}, nil
}
