package main

import (
	"context"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/manager"
)

func (d *discoveryServer) UpdateCategory(ctx context.Context, req *discovery.UpdateCategoryRequest) (*discovery.UpdateCategoryResponse, error) {
	err := data.ValidateUpdateCategory(req)
	if err != nil {
		return nil, err
	}

	m, err := manager.LoadDiscoveryManager(ctx)
	if err != nil {
		return nil, err
	}

	cat, err := m.UpdateCategory(ctx, req)
	if err != nil {
		return nil, err
	}

	return &discovery.UpdateCategoryResponse{
		Category: cat,
	}, nil
}
