package main

import (
	"context"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/manager"
)

func (d *discoveryServer) UpdateFeaturedCarousel(ctx context.Context, req *discovery.UpdateFeaturedCarouselRequest) (*discovery.UpdateFeaturedCarouselResponse, error) {
	err := data.ValidateUpdateFeaturedCarousel(req)
	if err != nil {
		return nil, err
	}

	m, err := manager.LoadDiscoveryManager(ctx)
	if err != nil {
		return nil, err
	}

	carousel, err := m.UpdateFeaturedCarousel(ctx, req)
	if err != nil {
		return nil, err
	}

	return &discovery.UpdateFeaturedCarouselResponse{
		FeaturedCarousel: carousel,
	}, nil
}
