package main

import (
	"context"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/manager"
)

func (d *discoveryServer) UpdateFeaturedCarouselEntry(ctx context.Context, req *discovery.UpdateFeaturedCarouselEntryRequest) (*discovery.UpdateFeaturedCarouselEntryResponse, error) {
	err := data.ValidateUpdateFeaturedCarouselEntry(req)
	if err != nil {
		return nil, err
	}

	m, err := manager.LoadDiscoveryManager(ctx)
	if err != nil {
		return nil, err
	}

	entry, err := m.UpdateFeaturedCarouselEntry(ctx, req)
	if err != nil {
		return nil, err
	}

	return &discovery.UpdateFeaturedCarouselEntryResponse{
		FeaturedCarouselEntry: entry,
	}, nil
}
