package main

import (
	"context"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/manager"
)

func (d *discoveryServer) UpdateFeaturedSchedule(ctx context.Context, req *discovery.UpdateFeaturedScheduleRequest) (*discovery.UpdateFeaturedScheduleResponse, error) {
	err := data.ValidateUpdateFeaturedSchedule(req)
	if err != nil {
		return nil, err
	}

	m, err := manager.LoadDiscoveryManager(ctx)
	if err != nil {
		return nil, err
	}

	schedule, err := m.UpdateFeaturedSchedule(ctx, req)
	if err != nil {
		return nil, err
	}

	return &discovery.UpdateFeaturedScheduleResponse{
		FeaturedSchedule: schedule,
	}, nil
}
