package migrations

import (
	"fmt"

	gormigrate "gopkg.in/gormigrate.v1"

	"github.com/jinzhu/gorm"
)

type CategoryTranslation struct{}
type CuratedCategoryExtension struct{}
type FeaturedCarouselDefault struct{}
type FeaturedCarouselEntry struct{}

// CategoriesAddForeignKeys adds foreign key constraints to the
// various Categories tables
var CategoriesAddForeignKeys = &gormigrate.Migration{
	ID: "201805160627",
	Migrate: func(tx *gorm.DB) error {
		tablePrefixInterface, ok := tx.Get("table_prefix")
		if !ok {
			return fmt.Errorf("missing table prefix")
		}
		tablePrefix := tablePrefixInterface.(string)
		err := tx.Model(&CategoryTranslation{}).
			AddForeignKey("category_id", tablePrefix+"_categories(id)", "CASCADE", "NO ACTION").
			AddForeignKey("language_code_id", tablePrefix+"_category_language_codes(id)", "CASCADE", "NO ACTION").Error

		if err != nil {
			return err
		}

		err = tx.Model(&CuratedCategoryExtension{}).
			AddForeignKey("category_id", tablePrefix+"_categories(id)", "CASCADE", "NO ACTION").Error

		if err != nil {
			return err
		}

		err = tx.Model(&FeaturedCarouselDefault{}).
			AddForeignKey("schedule_id", tablePrefix+"_featured_carousel_schedules(id)", "CASCADE", "NO ACTION").Error

		if err != nil {
			return err
		}

		return tx.Model(&FeaturedCarouselEntry{}).
			AddForeignKey("carousel_id", tablePrefix+"_featured_carousel_schedules(id)", "CASCADE", "NO ACTION").Error
	},
	Rollback: func(tx *gorm.DB) error {
		tablePrefixInterface, ok := tx.Get("table_prefix")
		if !ok {
			return fmt.Errorf("missing table prefix")
		}
		tablePrefix := tablePrefixInterface.(string)

		err := tx.Model(&CategoryTranslation{}).
			RemoveForeignKey("category_id", tablePrefix+"_categories(id)").
			RemoveForeignKey("language_code_id", tablePrefix+"_category_language_codes(id)").Error

		if err != nil {
			return err
		}

		err = tx.Model(&CuratedCategoryExtension{}).
			RemoveForeignKey("category_id", tablePrefix+"_categories(id)").Error

		if err != nil {
			return err
		}

		err = tx.Model(&FeaturedCarouselDefault{}).
			RemoveForeignKey("schedule_id", tablePrefix+"_featured_carousel_schedules(id)").Error

		if err != nil {
			return err
		}

		return tx.Model(&FeaturedCarouselEntry{}).
			RemoveForeignKey("carousel_id", tablePrefix+"_featured_carousel_schedules(id)").Error
	},
}
