package migrations

import (
	"fmt"

	gormigrate "gopkg.in/gormigrate.v1"

	"github.com/jinzhu/gorm"
)

// CategoriesAddSlugs adds foreign key constraints to the
// various Categories tables
var CategoriesAddSlugs = &gormigrate.Migration{
	ID: "201805251200",
	Migrate: func(tx *gorm.DB) error {

		type Category struct {
			Slug string `gorm:"unique_index"`
		}

		err := tx.AutoMigrate(&Category{}).Error
		if err != nil {
			return err
		}

		return nil
	},
	Rollback: func(tx *gorm.DB) error {
		tablePrefixInterface, ok := tx.Get("table_prefix")
		if !ok {
			return fmt.Errorf("missing table prefix")
		}
		tablePrefix := tablePrefixInterface.(string)

		err := tx.
			Table(tablePrefix + "_categories").
			RemoveIndex(tablePrefix + "_categories_slug_unique_idx").
			DropColumn("slugs").Error
		if err != nil {
			return err
		}

		return nil
	},
}
