package migrations

import (
	"fmt"

	gormigrate "gopkg.in/gormigrate.v1"

	"github.com/jinzhu/gorm"
)

// CarouselEntriesRemoveForeignKey removes an incorrect foreign key for carousel entries
var CarouselEntriesRemoveForeignKey = &gormigrate.Migration{
	ID: "201805290300",
	Migrate: func(tx *gorm.DB) error {
		tablePrefixInterface, ok := tx.Get("table_prefix")
		if !ok {
			return fmt.Errorf("missing table prefix")
		}
		tablePrefix := tablePrefixInterface.(string)

		return tx.Model(&FeaturedCarouselEntry{}).
			RemoveForeignKey("carousel_id", tablePrefix+"_featured_carousel_schedules(id)").Error
	},
	Rollback: func(tx *gorm.DB) error {
		tablePrefixInterface, ok := tx.Get("table_prefix")
		if !ok {
			return fmt.Errorf("missing table prefix")
		}
		tablePrefix := tablePrefixInterface.(string)

		return tx.Model(&FeaturedCarouselEntry{}).
			AddForeignKey("carousel_id", tablePrefix+"_featured_carousel_schedules(id)", "CASCADE", "NO ACTION").Error
	},
}

// CarouselEntriesAddForeignKey adds an incorrect foreign key for carousel entries
var CarouselEntriesAddForeignKey = &gormigrate.Migration{
	ID: "201805290315",
	Migrate: func(tx *gorm.DB) error {
		tablePrefixInterface, ok := tx.Get("table_prefix")
		if !ok {
			return fmt.Errorf("missing table prefix")
		}
		tablePrefix := tablePrefixInterface.(string)

		return tx.Model(&FeaturedCarouselEntry{}).
			AddForeignKey("carousel_id", tablePrefix+"_featured_carousels(id)", "CASCADE", "NO ACTION").Error
	},
	Rollback: func(tx *gorm.DB) error {
		tablePrefixInterface, ok := tx.Get("table_prefix")
		if !ok {
			return fmt.Errorf("missing table prefix")
		}
		tablePrefix := tablePrefixInterface.(string)

		return tx.Model(&FeaturedCarouselEntry{}).
			RemoveForeignKey("carousel_id", tablePrefix+"_featured_carousels(id)").Error
	},
}
