package migrations

import (
	"fmt"

	gormigrate "gopkg.in/gormigrate.v1"

	"github.com/jinzhu/gorm"
)

// FeaturedCarouselsEntryContent makes the entry content explicit instead of a json string
var FeaturedCarouselsEntryContent = &gormigrate.Migration{
	ID: "201806040224",
	Migrate: func(tx *gorm.DB) error {
		tablePrefixInterface, ok := tx.Get("table_prefix")
		if !ok {
			return fmt.Errorf("missing table prefix")
		}
		tablePrefix := tablePrefixInterface.(string)

		type FeaturedCarouselEntry struct {
			ClickThrough string
			ImageURL     string
			Title        string
		}
		err := tx.Table(tablePrefix + "_featured_carousel_entries").DropColumn("content").Error
		if err != nil {
			return err
		}
		return tx.AutoMigrate(&FeaturedCarouselEntry{}).Error
	},
	Rollback: func(tx *gorm.DB) error {
		tablePrefixInterface, ok := tx.Get("table_prefix")
		if !ok {
			return fmt.Errorf("missing table prefix")
		}
		tablePrefix := tablePrefixInterface.(string)

		err := tx.Table(tablePrefix + "_featured_carousel_entries").DropColumn("click_through").Error
		if err != nil {
			return err
		}
		err = tx.Table(tablePrefix + "_featured_carousel_entries").DropColumn("image_url").Error
		if err != nil {
			return err
		}
		err = tx.Table(tablePrefix + "_featured_carousel_entries").DropColumn("title").Error
		if err != nil {
			return err
		}
		type FeaturedCarouselEntry struct {
			Content string
		}
		return tx.AutoMigrate(&FeaturedCarouselEntry{}).Error
	},
}
