package migrations

import (
	"fmt"
	"time"

	gormigrate "gopkg.in/gormigrate.v1"

	"github.com/jinzhu/gorm"
)

// FeaturedCarouselsRefactor changes the schema for featured carousels
// per our redesign on 5/21/2018
var FeaturedCarouselsRefactor = &gormigrate.Migration{
	ID: "201805210305",
	Migrate: func(tx *gorm.DB) error {
		tablePrefixInterface, ok := tx.Get("table_prefix")
		if !ok {
			return fmt.Errorf("missing table prefix")
		}
		tablePrefix := tablePrefixInterface.(string)

		type FeaturedCarouselSchedule struct {
		}
		type FeaturedCarousel struct {
			Timestamps
			ID         string `gorm:"primary_key"`
			Schedule   FeaturedCarouselSchedule
			ScheduleID string
			StartTime  time.Time
		}
		err := tx.AutoMigrate(&FeaturedCarousel{}).Error
		if err != nil {
			return err
		}
		err = tx.Table(tablePrefix + "_featured_carousel_entries").DropColumn("start_time").Error
		if err != nil {
			return err
		}
		err = tx.Table(tablePrefix + "_featured_carousel_schedules").DropColumn("start_time").Error
		if err != nil {
			return err
		}
		return tx.Table(tablePrefix + "_featured_carousel_schedules").DropColumn("end_time").Error
	},
	Rollback: func(tx *gorm.DB) error {
		tablePrefixInterface, ok := tx.Get("table_prefix")
		if !ok {
			return fmt.Errorf("missing table prefix")
		}
		tablePrefix := tablePrefixInterface.(string)

		type FeaturedCarouselSchedule struct {
			StartTime time.Time
			EndType   *time.Time
		}
		type FeaturedCarouselEntry struct {
			StartTime time.Time
		}

		err := tx.DropTable(tablePrefix + "_featured_carousels").Error
		if err != nil {
			return err
		}
		return tx.AutoMigrate(&FeaturedCarouselSchedule{}, &FeaturedCarouselEntry{}).Error
	},
}
