package migrations

import (
	"time"

	"github.com/jinzhu/gorm"
	"github.com/jinzhu/gorm/dialects/postgres"
	"github.com/lib/pq"

	"gopkg.in/gormigrate.v1"
)

// DiscoveryAddHstore is needed to enable the hstore type
var DiscoveryAddHstore = &gormigrate.Migration{
	ID: "201903210752",
	Migrate: func(tx *gorm.DB) error {
		result := tx.Exec("CREATE EXTENSION hstore;")

		return result.Error
	},
	Rollback: func(tx *gorm.DB) error {
		return nil
	},
}

// DiscoverySetupTables creates new discovery tables not from the original categories
var DiscoverySetupTables = &gormigrate.Migration{
	ID: "201905171352",
	Migrate: func(tx *gorm.DB) error {

		type ExtensionDiscoveryData struct {
			Timestamps
			DeletedAt time.Time

			// Identifiers
			ExtensionID string `gorm:"primary_key"`
			Version     string `gorm:"primary_key"`

			// Values
			AuthorName       string
			Categories       pq.StringArray `gorm:"type:varchar[]"`
			Description      string
			EULATOSURL       string
			Games            pq.Int64Array `gorm:"type:bigint[]"`
			IconPaths        postgres.Hstore
			IconURLs         postgres.Hstore
			Name             string
			PrivacyPolicyURL string
			ScreenshotPaths  pq.StringArray `gorm:"type:varchar[]"`
			ScreenshotURLs   pq.StringArray `gorm:"type:varchar[]"`
			Summary          string
			SupportEmail     string
			ViewerSummary    string
		}

		return tx.AutoMigrate(
			&ExtensionDiscoveryData{},
		).Error
	},
	Rollback: func(tx *gorm.DB) error {
		return nil
	},
}
