package migrations

import (
	"fmt"

	gormigrate "gopkg.in/gormigrate.v1"

	"github.com/jinzhu/gorm"
)

// SchedulesAddSlugs adds a unique slug field to the schedule table
var SchedulesAddSlugs = &gormigrate.Migration{
	ID: "201806010300",
	Migrate: func(tx *gorm.DB) error {

		type FeaturedCarouselSchedule struct {
			Slug string `gorm:"unique_index"`
		}

		err := tx.AutoMigrate(&FeaturedCarouselSchedule{}).Error
		if err != nil {
			return err
		}

		return nil
	},
	Rollback: func(tx *gorm.DB) error {
		tablePrefixInterface, ok := tx.Get("table_prefix")
		if !ok {
			return fmt.Errorf("missing table prefix")
		}
		tablePrefix := tablePrefixInterface.(string)

		err := tx.
			Table(tablePrefix + "_featured_carousel_schedules").
			RemoveIndex(tablePrefix + "_featured_carousel_schedules_slug_unique_idx").
			DropColumn("slugs").Error
		if err != nil {
			return err
		}

		return nil
	},
}
