package migrations

import (
	"time"

	gormigrate "gopkg.in/gormigrate.v1"

	"github.com/jinzhu/gorm"
)

// CategoriesSetupTables creates the initial category tables
var CategoriesSetupTables = &gormigrate.Migration{
	ID: "201805160429",
	Migrate: func(tx *gorm.DB) error {
		type Category struct {
			Timestamps
			ID       string `gorm:"primary_key"`
			Type     string
			Order    float32
			SortKey  string
			Visible  bool `gorm:"default:false"`
			Readonly bool `gorm:"default:false"`
			Deleted  bool `gorm:"default:false"`
		}

		type FeaturedCarouselSchedule struct {
			Timestamps
			ID          string `gorm:"primary_key"`
			Description string
			StartTime   time.Time
			EndTime     *time.Time
		}

		type CategoryLanguageCode struct {
			Timestamps
			ID   string `gorm:"primary_key"`
			Code string `gorm:"default:'en_us'"`
		}

		type FeaturedCarouselEntry struct {
			Timestamps
			ID         string `gorm:"primary_key"`
			Carousel   FeaturedCarouselSchedule
			CarouselID string
			Content    string
			Order      float32
			StartTime  time.Time
		}

		type FeaturedCarouselDefault struct {
			Schedule   FeaturedCarouselSchedule
			ScheduleID string
		}

		type CuratedCategoryExtension struct {
			Timestamps
			Category    Category
			CategoryID  string
			ExtensionID string
			StartTime   *time.Time
			Order       float32
		}

		type CategoryTranslation struct {
			Timestamps
			Category       Category
			CategoryID     string
			LanguageCode   CategoryLanguageCode
			LanguageCodeID string
			Name           string
			Description    string
		}

		return tx.AutoMigrate(
			&FeaturedCarouselSchedule{},
			&FeaturedCarouselEntry{},
			&FeaturedCarouselDefault{},
			&CuratedCategoryExtension{},
			&CategoryTranslation{},
			&CategoryLanguageCode{},
			&Category{},
		).Error
	},
	Rollback: func(tx *gorm.DB) error {
		return nil
	},
}
