package model

import "github.com/jinzhu/gorm"

var (
	CategoryTypeCurated   = "curated"
	CategoryTypeDeveloper = "developer"

	// CategoryTypePseudo are for categories which shouldn't be listed in a get
	// all categories listing but should be retrievable by a slug
	CategoryTypePseudo = "pseudo"

	// PseudoCategorySlugWhitelisted is the expected slug name of the "whitelisted" pseudo category
	PseudoCategorySlugWhitelisted = "whitelisted"
	PseudoCategorySlugNewReleases = "new-releases"

	CategorySortkeyPopularity = "popularity"
	CategorySortkeyManual     = "manual"
	CategorySortkeyTime       = "time"
)

type Category struct {
	Timestamps
	ID       string `gorm:"primary_key"`
	Type     string
	Order    float32
	Slug     *string
	SortKey  string
	Visible  bool `gorm:"default:false"`
	Readonly bool `gorm:"default:false"`
	Deleted  bool `gorm:"default:false"`
}

func (cat *Category) BeforeCreate(scope *gorm.Scope) error {
	return AddUUID(scope)
}
