package model

import (
	"time"

	"github.com/jinzhu/gorm/dialects/postgres"
	"github.com/lib/pq"
)

// ExtensionDiscoveryData tracks data related to discovering extensions
type ExtensionDiscoveryData struct {
	Timestamps
	// DeletedAt used by gorm for soft deletes
	DeletedAt time.Time

	// Identifiers
	ExtensionID string `gorm:"primary_key"`
	Version     string `gorm:"primary_key"`

	// Values
	AuthorName       string
	Categories       pq.StringArray `gorm:"type:varchar[]"`
	Description      string
	EULATOSURL       string
	Games            pq.Int64Array `gorm:"type:bigint[]"`
	IconPaths        postgres.Hstore
	IconURLs         postgres.Hstore
	Name             string
	PrivacyPolicyURL string
	ScreenshotPaths  pq.StringArray `gorm:"type:varchar[]"`
	ScreenshotURLs   pq.StringArray `gorm:"type:varchar[]"`
	Summary          string
	SupportEmail     string
	ViewerSummary    string
}
