package memory

import (
	"time"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data/model"
)

func (s *store) AddExtensionToCategory(req *discovery.AddExtensionToCategoryRequest) (*model.CuratedCategoryExtension, error) {
	defer s.mutex.Unlock()
	s.mutex.Lock()

	var startTime *time.Time
	if req.GetStartTime() != nil {
		t := time.Unix(req.GetStartTime().GetSeconds(), int64(req.GetStartTime().GetNanos()))
		startTime = &t
	}

	var order float32
	if req.GetOrder() != nil {
		order = req.GetOrder().GetValue()
	} else {
		order = float32(len(s.categoriesToExtensions[req.GetCategoryID()]))
	}

	entry := model.CuratedCategoryExtension{
		CategoryID:  req.GetCategoryID(),
		ExtensionID: req.GetExtensionID(),
		StartTime:   startTime,
		Order:       order,
	}

	categories, ok := s.extensionsToCategories[req.GetExtensionID()]
	if !ok {
		categories = []*model.CuratedCategoryExtension{}
	}
	categories = append(categories, &entry)
	s.extensionsToCategories[req.GetExtensionID()] = categories

	extensions, ok := s.categoriesToExtensions[req.GetCategoryID()]
	if !ok {
		extensions = []*model.CuratedCategoryExtension{}
	}
	extensions = append(extensions, &entry)
	s.categoriesToExtensions[req.GetCategoryID()] = extensions

	return &entry, nil
}
