package memory

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"
)

func (s *store) AdminGetDiscoveryData(req *discovery.GetExtensionVersionDiscoveryDataRequest) (*model.ExtensionDiscoveryData, error) {
	defer s.mutex.Unlock()
	s.mutex.Lock()

	versions, ok := s.extensionsDiscoveryData[req.GetExtensionID()]
	if !ok {
		return nil, data.ErrNotFound
	}

	discoData, ok := versions[req.GetVersion()]
	if !ok {
		return nil, data.ErrNotFound
	}

	return discoData, nil
}
