package memory

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"
	"code.justin.tv/extensions/discovery/twirputils"
)

func (s *store) CreateCategory(req *discovery.AddCategoryRequest) (*model.Category, error) {
	category := req.GetCategory()

	err := data.ValidateCategoryUpsert(category, false)
	if err != nil {
		return nil, err
	}

	defer s.mutex.Unlock()
	s.mutex.Lock()

	id, err := s.uuid.Next()
	if err != nil {
		return nil, err
	}

	readonly := category.GetReadonly() != nil && category.GetReadonly().GetValue()
	var order float32
	if category.GetOrder() != nil {
		order = category.GetOrder().GetValue()
	} else {
		order = float32(len(s.categories))
	}
	slug := twirputils.UnwrapStringValuePointer(category.GetSlug())
	cat := model.Category{
		ID:       id,
		Type:     category.GetType().GetValue(),
		Slug:     slug,
		SortKey:  category.GetSortKey().GetValue(),
		Readonly: readonly,
		Visible:  false,
		Deleted:  false,
		Order:    order,
	}

	if category.GetVisible() != nil {
		cat.Visible = category.GetVisible().GetValue()
	}

	if cat.Slug != nil {
		if _, ok := s.categoriesBySlug[*cat.Slug]; ok {
			return nil, data.ErrSlugTaken
		}

		s.categoriesBySlug[*cat.Slug] = &cat
	}

	s.categories[cat.ID] = &cat

	return &cat, nil
}
