package memory

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data/model"
	"code.justin.tv/extensions/discovery/twirputils"
)

func (s *store) CreateFeaturedCarousel(req *discovery.AddFeaturedCarouselRequest) (*model.FeaturedCarousel, error) {
	defer s.mutex.Unlock()
	s.mutex.Lock()

	id, err := s.uuid.Next()
	if err != nil {
		return nil, err
	}

	startTime, err := twirputils.UnwrapTimestampPointer(req.GetFeaturedCarousel().GetStartTime())
	if err != nil {
		return nil, err
	}

	carousel := &model.FeaturedCarousel{
		ID:         id,
		ScheduleID: req.GetFeaturedCarousel().GetScheduleID(),
		StartTime:  *startTime,
	}

	s.featuredCarousels[id] = carousel
	s.scheduleIDsToCarousels[req.GetFeaturedCarousel().GetScheduleID()] = carousel

	return carousel, nil
}
