package memory

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"
)

func (s *store) CreateFeaturedCarouselEntry(req *discovery.AddFeaturedCarouselEntryRequest) (*model.FeaturedCarouselEntry, error) {
	defer s.mutex.Unlock()
	s.mutex.Lock()

	if req.GetFeaturedCarouselEntry().GetCarouselID() == nil {
		return nil, data.ErrMissingEntryCarouselID
	}

	cid := req.GetFeaturedCarouselEntry().GetCarouselID().GetValue()

	if req.GetFeaturedCarouselEntry().GetContent() == nil {
		return nil, data.ErrMissingEntryContent
	}

	content := req.GetFeaturedCarouselEntry().GetContent()

	var order float32
	if req.GetFeaturedCarouselEntry().GetOrder() != nil {
		order = req.GetFeaturedCarouselEntry().GetOrder().GetValue()
	} else {
		order = float32(len(s.carouselsToEntries[req.GetFeaturedCarouselEntry().GetCarouselID().GetValue()]))
	}

	id, err := s.uuid.Next()
	if err != nil {
		return nil, err
	}

	entry := &model.FeaturedCarouselEntry{
		ID:           id,
		CarouselID:   cid,
		ClickThrough: content.ClickThrough,
		ImageURL:     content.ImageURL,
		Title:        content.Title,
		Order:        order,
	}

	s.featuredCarouselEntries[id] = entry

	entries, ok := s.carouselsToEntries[cid]
	if !ok {
		entries = []*model.FeaturedCarouselEntry{}
	}
	entries = append(entries, entry)
	s.carouselsToEntries[cid] = entries

	return entry, nil
}
