package memory

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"
	"code.justin.tv/extensions/discovery/twirputils"
)

func (s *store) CreateFeaturedSchedule(req *discovery.AddFeaturedScheduleRequest) (*model.FeaturedCarouselSchedule, error) {
	defer s.mutex.Unlock()
	s.mutex.Lock()

	id, err := s.uuid.Next()
	if err != nil {
		return nil, err
	}

	schedule := &model.FeaturedCarouselSchedule{
		ID:          id,
		Description: req.GetFeaturedSchedule().GetDescription(),
		Slug:        twirputils.UnwrapStringValuePointer(req.GetFeaturedSchedule().GetSlug()),
	}

	s.featuredCarouselSchedules[id] = schedule

	if schedule.Slug != nil {
		if _, ok := s.featuredCarouselSchedulesBySlug[*schedule.Slug]; ok {
			return nil, data.ErrSlugTaken
		}

		s.featuredCarouselSchedulesBySlug[*schedule.Slug] = schedule
	}
	return schedule, nil
}
