package memory

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
)

func (s *store) DeleteCategory(req *discovery.DeleteCategoryRequest) error {
	defer s.mutex.Unlock()
	s.mutex.Lock()

	cat, ok := s.categories[req.GetCategoryID()]
	if !ok {
		return data.ErrNotFound
	}

	if req.GetSoftDelete() {
		cat.Deleted = true
		s.categories[req.GetCategoryID()] = cat
	} else {
		delete(s.categories, req.GetCategoryID())
	}

	return nil
}
