package memory

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"
)

func (s *store) DeleteFeaturedCarousel(req *discovery.DeleteFeaturedCarouselRequest) (*model.FeaturedCarousel, error) {
	defer s.mutex.Unlock()
	s.mutex.Lock()

	carousel, ok := s.featuredCarousels[req.GetCarouselID()]
	if !ok {
		return nil, data.ErrNotFound
	}

	delete(s.featuredCarousels, req.GetCarouselID())
	delete(s.scheduleIDsToCarousels, carousel.ScheduleID)

	return carousel, nil
}
