package memory

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"
)

func (s *store) DeleteFeaturedCarouselEntry(req *discovery.DeleteFeaturedCarouselEntryRequest) (*model.FeaturedCarouselEntry, error) {
	defer s.mutex.Unlock()
	s.mutex.Lock()

	entry, ok := s.featuredCarouselEntries[req.GetID()]
	if !ok {
		return nil, data.ErrNotFound
	}

	delete(s.featuredCarouselEntries, req.GetID())

	entries := s.carouselsToEntries[entry.CarouselID]
	for i, entry := range entries {
		if entry.ID == req.GetID() {
			entries[i] = entries[len(entries)-1]
			entries = entries[:len(entries)-1]
			s.carouselsToEntries[entry.CarouselID] = entries
			break
		}
	}

	return entry, nil
}
