package memory

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"
)

func (s *store) EditCategoryTranslation(req *discovery.EditCategoryTranslationRequest) (*model.CategoryTranslation, *model.Category, error) {
	defer s.mutex.Unlock()
	s.mutex.Lock()

	cat, ok := s.categories[req.GetCategoryID()]
	if !ok {
		return nil, nil, data.ErrCategoryNotFound
	}

	languageCode, err := s.getOrCreateLanguageCode(req.GetLanguage())
	if err != nil {
		return nil, nil, err
	}

	translationMap, ok := s.translations[req.GetCategoryID()]
	if !ok {
		translationMap = make(map[string]*model.CategoryTranslation)
	}
	translation := &model.CategoryTranslation{
		Name:        req.GetName(),
		Description: req.GetDescription(),
	}
	translationMap[languageCode.ID] = translation
	s.translations[req.GetCategoryID()] = translationMap
	return translation, cat, nil
}
